
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Nov 29 19:51:53 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief HASH external application ATP menu
   *
   *  \version CRYS_Ext_ATP_TST_HASH_MAIN.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */

/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_Ext_ATP_HASH_Acceptance.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"

#include <stdio.h>
#include "DX_VOS_Mem.h"

/******** Defines ********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
/***** Private function prototype ******/
CRYSError_t CRYS_ExtApp_ATP_HASH_Acceptance_ALL_TESTS(void);


/******** Public Functions *****/
void CRYS_ExtApp_ATP_HASH_main(void)
{
  DxUint8_t  Var;

  do
   {
	   do
	   {
	           ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n\n--[ Ext SEP application HASH tests Menu ]---------------------------------"));
	           ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [1] - Acceptance NON integrated "));
	           ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [2] - Acceptance Integrated"));
			   
			   
	           ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [T] - ALL Ext SEP application AES Acceptance tests                      "));
			   ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [Z] - End of tests return to prev menu			   "));
	           ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------\n\n"));
	           scanf("\n%c",&Var);
	           ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n Test = %c\n",Var));
	           if (Var<='Z')
	                    break;
	           else
	           {
	                 ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
	           }

	    }while(1);


	    switch(Var)
	    {
		  	case '1':
				    CRYS_ExtApp_ATP_HASH_NON_integrated();
				    break;
		  	case '2':
				    CRYS_ExtApp_ATP_HASH_Integrated();
				    break;
			
		  	case 'T':
		  			CRYS_ExtApp_ATP_HASH_Acceptance_ALL_TESTS();
				    break;
	       	case 'Z':
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n End of AES tests \n"));
	                break ;

	       	default:
	              ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
	    }
	       if(Var =='Z')
	       break;
     }while (1);
}


/******** Private Functions **********/
/***************************
 * Function Name:
 * 	CRYS_ExtApp_ATP_HASH_Acceptance_ALL_TESTS
 *
 * Inputs:
 * 	none
 *
 * Outputs:
 * 	CRYSError_t - Function error return
 *
 * Description:
 * This function runs all of the external application HASH Acceptance tests
 *
 **************************/
CRYSError_t CRYS_ExtApp_ATP_HASH_Acceptance_ALL_TESTS(void)
{
    CRYSError_t TST_ATP_AES_Error = TESTPASS;

    TST_ATP_Error = CRYS_ExtApp_ATP_HASH_NON_integrated();
    TST_ATP_AES_Error = TST_ATP_AES_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_AES_Error != TESTPASS)
			    return 	TST_ATP_AES_Error;
    #endif

    TST_ATP_Error = CRYS_ExtApp_ATP_HASH_Integrated();
    TST_ATP_AES_Error = TST_ATP_AES_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_AES_Error != TESTPASS)
			    return 	TST_ATP_AES_Error;
    #endif

    

		/*Check if all tests pass*/
		if (TST_ATP_AES_Error != TESTPASS)
			{
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE AES TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
			}
			else
			{
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE EXT SEP APPLICATION HASH Acceptance TESTS PASS   :-)         ***\n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
			}
		return TST_ATP_AES_Error;

}




